#include "HelloApp.h"
#include "BlitheDictionary.h"
#include <MenuBar.h>
#include <MenuItem.h>
#include <Window.h>
#include <StringView.h>
#include <Application.h>

HelloApp::HelloApp(void) : BApplication("application/x-vnd.Bastion-HelloWorld")
{
	langWin = NULL;

// Create the dictionary
	appDictionary = new BlitheDictionary(BL_DEFAULT_LANGUAGE);

// Create the window
	appWindow = new BWindow(BRect(100,100,300,150),"temp",B_TITLED_WINDOW,B_NOT_RESIZABLE | B_NOT_CLOSABLE | B_NOT_ZOOMABLE);
	BMenuBar *theMenuBar = new BMenuBar(BRect(0,0,20,20),"mbar");
	BMenu *theMenu = new BMenu("temp");
	theMenuBar->AddItem(theMenu);
	BMenuItem *theMenuItem = new BMenuItem("temp",new BMessage(B_QUIT_REQUESTED),'Q');
	theMenuItem->SetTarget(this);
	theMenu->AddItem(theMenuItem);
	appWindow->AddChild(theMenuBar);
	BRect frame = appWindow->Bounds();
	frame.top = theMenuBar->Bounds().Height()+1;
	BStringView *theStringView = new BStringView(frame,"hello","temp");
	BFont theFont;
	theStringView->GetFont(&theFont);
	theFont.SetSize(24.0);
	theStringView->SetFont(&theFont,B_FONT_SIZE);
	appWindow->AddChild(theStringView);

	UpdateLanguage();
	appWindow->Show();
}

HelloApp::~HelloApp(void)
{
	delete appDictionary;
}

void HelloApp::MessageReceived(BMessage *message)
{
	int32 language;
	status_t err;
	switch (message->what)
	{
	case BLITHE_LANGUAGE_CHANGED:
	case BLITHE_UPDATE_LANGUAGE:
		if (langWin)
		{
			langWin->PostMessage(B_QUIT_REQUESTED);
			langWin = NULL;
		}
		err = message->FindInt32("langid",&language);
		if (err != B_OK) return;
		appDictionary->SetAppLanguage(language);
		UpdateLanguage();
		break;
	default:
		BApplication::MessageReceived(message);
		break;
	}
}

void HelloApp::UpdateLanguage(void)
{
// Lock the window
	if (!appWindow->Lock()) return;

// Update the window title
	appWindow->SetTitle(appDictionary->Entry(HELLO_WORLD_STRING,BL_APP_LANGUAGE));

// Update the text
	BStringView *theText = dynamic_cast<BStringView*>(appWindow->FindView("hello"));
	if (!theText) return;
	theText->SetText(appDictionary->Entry(HELLO_WORLD_STRING,BL_APP_LANGUAGE));

// Update the menu
	BMenuBar *theMenuBar = dynamic_cast<BMenuBar*>(appWindow->FindView("mbar"));
	if (!theMenuBar) return;
	BMenuItem *theMenuItem = theMenuBar->ItemAt(0);
	theMenuItem->SetLabel(appDictionary->Entry(BL_FILE_STRING,BL_APP_LANGUAGE));
	BMenu *theMenu = theMenuItem->Submenu();
	theMenuItem = theMenu->FindItem(B_QUIT_REQUESTED);
	theMenuItem->SetLabel(appDictionary->Entry(BL_QUIT_STRING,BL_APP_LANGUAGE));

// Unlock the window
	appWindow->Unlock();
}